// AcMapOrclApiTestConnectDlg.cpp : implementation file
//
///////////////////////////////////////////////////////////////////////////////
// (C) Copyright 2001 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// CREATED BY:
//	Hugues Wisniewski, June 2001
//
// DESCRIPTION:
// 	Implementation of class AcMapOrclApiTestConnectDlg

#include "stdafx.h"
#include "AcMapOrclApiTestConnectDlg.h"
#include "AcMapOracleConnection.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AcMapOrclApiTestConnectDlg dialog


AcMapOrclApiTestConnectDlg::AcMapOrclApiTestConnectDlg(CWnd* pParent /*=NULL*/)
	: CDialog(AcMapOrclApiTestConnectDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(AcMapOrclApiTestConnectDlg)
	m_strPassword = _T("");
	m_strService = _T("");
	m_strUserName = _T("");
	//}}AFX_DATA_INIT
}


void AcMapOrclApiTestConnectDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(AcMapOrclApiTestConnectDlg)
	DDX_Text(pDX, IDC_EDIT_PASSWORD, m_strPassword);
	DDX_Text(pDX, IDC_EDIT_SERVICE, m_strService);
	DDX_Text(pDX, IDC_EDIT_USER_NAME, m_strUserName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(AcMapOrclApiTestConnectDlg, CDialog)
	//{{AFX_MSG_MAP(AcMapOrclApiTestConnectDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// AcMapOrclApiTestConnectDlg message handlers

//******************************************************************************************
BOOL AcMapOrclApiTestConnectDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	AcMapOracleConnection *pConnection=AcMapOracleGetConnection();
	m_strService=pConnection->Service();
	m_strUserName=pConnection->UserName();
	m_strPassword="";

	UpdateData(false);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

//******************************************************************************************
void AcMapOrclApiTestConnectDlg::OnOK() 
{
	UpdateData(true);

	AcMapOracleConnection *pConnection=AcMapOracleGetConnection();

	if (pConnection->IsConnected())
	{
		pConnection->Disconnect();
	}

	if (!pConnection->Connect(
		(const char*)m_strUserName, 
		(const char*)m_strService, 
		(const char*)m_strUserName, 
		(const char*)m_strPassword))
	{
		AfxMessageBox("Failed to connect");
		return;
	}

	acutPrintf("\nConnected to Oracle");
	
	CDialog::OnOK();
}
